/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.codec;

import com.itextpdf.text.error_messages.MessageLocalization;

public class TIFFLZWDecoder {
    byte[][] stringTable;
    byte[] data = null;
    byte[] uncompData;
    int tableIndex;
    int bitsToGet = 9;
    int bytePointer;
    int bitPointer;
    int dstIndex;
    int w;
    int h;
    int predictor;
    int samplesPerPixel;
    int nextData = 0;
    int nextBits = 0;
    int[] andTable = new int[]{511, 1023, 2047, 4095};

    public TIFFLZWDecoder(int w, int predictor, int samplesPerPixel) {
        this.w = w;
        this.predictor = predictor;
        this.samplesPerPixel = samplesPerPixel;
    }

    public byte[] decode(byte[] data, byte[] uncompData, int h2) {
        int code;
        if (data[0] == 0 && data[1] == 1) {
            throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("tiff.5.0.style.lzw.codes.are.not.supported", new Object[0]));
        }
        this.initializeStringTable();
        this.data = data;
        this.h = h2;
        this.uncompData = uncompData;
        this.bytePointer = 0;
        this.bitPointer = 0;
        this.dstIndex = 0;
        this.nextData = 0;
        this.nextBits = 0;
        int oldCode = 0;
        while ((code = this.getNextCode()) != 257 && this.dstIndex < uncompData.length) {
            byte[] string;
            if (code == 256) {
                this.initializeStringTable();
                code = this.getNextCode();
                if (code == 257) break;
                this.writeString(this.stringTable[code]);
                oldCode = code;
                continue;
            }
            if (code < this.tableIndex) {
                string = this.stringTable[code];
                this.writeString(string);
                this.addStringToTable(this.stringTable[oldCode], string[0]);
                oldCode = code;
                continue;
            }
            string = this.stringTable[oldCode];
            string = this.composeString(string, string[0]);
            this.writeString(string);
            this.addStringToTable(string);
            oldCode = code;
        }
        if (this.predictor == 2) {
            for (int j2 = 0; j2 < h2; ++j2) {
                int count = this.samplesPerPixel * (j2 * this.w + 1);
                for (int i2 = this.samplesPerPixel; i2 < this.w * this.samplesPerPixel; ++i2) {
                    int n2 = count;
                    uncompData[n2] = (byte)(uncompData[n2] + uncompData[count - this.samplesPerPixel]);
                    ++count;
                }
            }
        }
        return uncompData;
    }

    public void initializeStringTable() {
        this.stringTable = new byte[4096][];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.stringTable[i2] = new byte[1];
            this.stringTable[i2][0] = (byte)i2;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    public void writeString(byte[] string) {
        int max = this.uncompData.length - this.dstIndex;
        if (string.length < max) {
            max = string.length;
        }
        System.arraycopy(string, 0, this.uncompData, this.dstIndex, max);
        this.dstIndex += max;
    }

    public void addStringToTable(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string = new byte[length + 1];
        System.arraycopy(oldString, 0, string, 0, length);
        string[length] = newString;
        this.stringTable[this.tableIndex++] = string;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] string) {
        this.stringTable[this.tableIndex++] = string;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string = new byte[length + 1];
        System.arraycopy(oldString, 0, string, 0, length);
        string[length] = newString;
        return string;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
                this.nextBits += 8;
            }
            int code = this.nextData >> this.nextBits - this.bitsToGet & this.andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return code;
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            return 257;
        }
    }
}

